using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static long CountInversions(List<long> arr)
    {
        return MergeSort(arr, 0, arr.Count - 1);
    }

    static long MergeSort(List<long> a, int l, int r)
    {
        if (l >= r) return 0;
        int m = (l + r) / 2;
        long inv = 0;
        inv += MergeSort(a, l, m);
        inv += MergeSort(a, m + 1, r);
        inv += Merge(a, l, m, r);
        return inv;
    }

    static long Merge(List<long> a, int l, int m, int r)
    {
        int i = l, j = m + 1;
        List<long> temp = new List<long>(r - l + 1);
        long inv = 0;

        while (i <= m && j <= r)
        {
            if (a[i] <= a[j])
            {
                temp.Add(a[i++]);
            }
            else
            {
                temp.Add(a[j++]);
                inv += (m - i + 1);
            }
        }

        while (i <= m) temp.Add(a[i++]);
        while (j <= r) temp.Add(a[j++]);

        for (int k = 0; k < temp.Count; k++)
            a[l + k] = temp[k];

        return inv;
    }

    static void Main()
    {
        int N = int.Parse(Console.ReadLine());
        var pts = new (long x, long y)[N];

        for (int i = 0; i < N; i++)
        {
            var s = Console.ReadLine().Split();
            pts[i] = (long.Parse(s[0]), long.Parse(s[1]));
        }

        long ans = 0;

        var mapY = new Dictionary<long, List<long>>();
        var mapX = new Dictionary<long, List<long>>();
        var mapD = new Dictionary<long, List<(long x, long y)>>();

        foreach (var p in pts)
        {
            if (!mapY.ContainsKey(p.y)) mapY[p.y] = new List<long>();
            mapY[p.y].Add(p.x);

            if (!mapX.ContainsKey(p.x)) mapX[p.x] = new List<long>();
            mapX[p.x].Add(p.y);

            long key = p.x - p.y;
            if (!mapD.ContainsKey(key)) mapD[key] = new List<(long, long)>();
            mapD[key].Add(p);
        }

        // Horizontal (E-W)
        foreach (var list in mapY.Values)
        {
            list.Sort();
            int L = list.Count;
            int a = 0, b = L - 1;
            while (a < b)
            {
                if (((list[b] - list[a]) & 1) == 0) ans++;
                a++; b--;
            }
        }

        // Vertical (N-S)
        foreach (var list in mapX.Values)
        {
            list.Sort();
            int L = list.Count;
            int a = 0, b = L - 1;
            while (a < b)
            {
                if (((list[b] - list[a]) & 1) == 0) ans++;
                a++; b--;
            }
        }

        // Diagonals ? count inversions by y after sorting by x
        foreach (var list in mapD.Values)
        {
            list.Sort((A, B) => A.x.CompareTo(B.x));
            var ys = list.Select(p => p.y).ToList();
            ans += CountInversions(ys);
        }

        Console.WriteLine(ans);
    }
}